'/***
'*float.h - constants for floating point values
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       This file contains defines for a number of implementation dependent
'*       values which are commonly used by sophisticated numerical (floating
'*       point) programs.
'*       [ANSI]
'*
'*       [Public]
'*
'****/

#If Not %Def(%FLOAT_INC)
    %FLOAT_INC = 1

%DBL_DIG              = 15                      ' /* # of decimal digits of precision */
Macro DBL_EPSILON     = 2.2204460492503131e-016 ' /* smallest such that 1.0+DBL_EPSILON != 1.0 */
%DBL_MANT_DIG         = 53                      ' /* # of bits in mantissa */
Macro DBL_MAX         = 1.7976931348623158e+308 ' /* max value */
%DBL_MAX_10_EXP       = 308                     ' /* max decimal exponent */
%DBL_MAX_EXP          = 1024                    ' /* max binary exponent */
Macro DBL_MIN         = 2.2250738585072014e-308 ' /* min positive value */
%DBL_MIN_10_EXP       = -307                    ' /* min decimal exponent */
%DBL_MIN_EXP          = -1021                   ' /* min binary exponent */
%DBL_RADIX            = 2                       ' /* exponent radix */
%DBL_ROUNDS           = 1                       ' /* addition rounding: near */

%FLT_DIG              = 6                       ' /* # of decimal digits of precision */
Macro FLT_EPSILON     = 1.192092896e-07!        ' /* smallest such that 1.0+FLT_EPSILON != 1.0 */
%FLT_GUARD            = 0
%FLT_MANT_DIG         = 24                      ' /* # of bits in mantissa */
Macro FLT_MAX         = 3.402823466e+38!        ' /* max value */
%FLT_MAX_10_EXP       = 38                      ' /* max decimal exponent */
%FLT_MAX_EXP          = 128                     ' /* max binary exponent */
Macro FLT_MIN         = 1.175494351e-38!        ' /* min positive value */
%FLT_MIN_10_EXP       = -37                     ' /* min decimal exponent */
%FLT_MIN_EXP          = -125                    ' /* min binary exponent */
%FLT_NORMALIZE        = 0
%FLT_RADIX            = 2                       ' /* exponent radix */
%FLT_ROUNDS           = 1                       ' /* addition rounding: near */

#If Not %Def(%M_M68K)
%LDBL_DIG             = %DBL_DIG                 ' /* # of decimal digits of precision */
Macro LDBL_EPSILON    = DBL_EPSILON              ' /* smallest such that 1.0+L= %DBL_EPSILON != 1.0 */
%LDBL_MANT_DIG        = %DBL_MANT_DIG            ' /* # of bits in mantissa */
Macro LDBL_MAX        = DBL_MAX                  ' /* max value */
%LDBL_MAX_10_EXP      = %DBL_MAX_10_EXP          ' /* max decimal exponent */
%LDBL_MAX_EXP         = %DBL_MAX_EXP             ' /* max binary exponent */
Macro LDBL_MIN        = DBL_MIN                  ' /* min positive value */
%LDBL_MIN_10_EXP      = %DBL_MIN_10_EXP          ' /* min decimal exponent */
%LDBL_MIN_EXP         = %DBL_MIN_EXP             ' /* min binary exponent */
%LDBL_RADIX           = %DBL_RADIX               ' /* exponent radix */
%LDBL_ROUNDS          = %DBL_ROUNDS              ' /* addition rounding: near */
#Else
%LDBL_DIG             = 18                             ' /* # of decimal digits of precision */
Macro LDBL_EPSILON    = 1.08420217248550443412e-019##  ' /* smallest such that 1.0+LDBL_EPSILON != 1.0 */
%LDBL_MANT_DIG        = 64                             ' /* # of bits in mantissa */
Macro LDBL_MAX        = 1.189731495357231765e+4932##   ' /* max value */
%LDBL_MAX_10_EXP      = 4932                           ' /* max decimal exponent */
%LDBL_MAX_EXP         = 16384                          ' /* max binary exponent */
Macro LDBL_MIN        = 3.3621031431120935063e-4932##  ' /* min positive value */
%LDBL_MIN_10_EXP      = -4931                          ' /* min decimal exponent */
%LDBL_MIN_EXP         = -16381                         ' /* min binary exponent */
%LDBL_RADIX           = 2                              ' /* exponent radix */
%LDBL_ROUNDS          = 1                              ' /* addition rounding: near */
#EndIf

'/* Function prototypes */

'_CRTIMP unsigned int __cdecl _clearfp(void);
Declare Function clearfp CDecl Lib "msvcrt.dll" Alias "_clearfp" ( _
   ) As Dword                               ' unsigned int

'_CRTIMP unsigned int __cdecl _controlfp(unsigned int,unsigned int);
Declare Function controlfp CDecl Lib "msvcrt.dll" Alias "_controlfp" ( _
   ByVal Dword, _                           ' unsigned int new
   ByVal Dword _                            ' unsigned int mask
   ) As Dword                               ' unsigned int

'_CRTIMP unsigned int __cdecl _statusfp(void);
Declare Function statusfp CDecl Lib "msvcrt.dll" Alias "_statusfp" ( _
   ) As Dword                               ' unsigned int

'_CRTIMP void __cdecl _fpreset(void);
Declare Sub fpreset CDecl Lib "msvcrt.dll" Alias "fpreset" ()

'/*
' * Abstract User Control Word Mask and bit definitions
' */
%MCW_EM         = &H0008001f???              ' /* interrupt Exception Masks */
%EM_INEXACT     = &H00000001???              ' /*   inexact (precision) */
%EM_UNDERFLOW   = &H00000002???              ' /*   underflow */
%EM_OVERFLOW    = &H00000004???              ' /*   overflow */
%EM_ZERODIVIDE  = &H00000008???              ' /*   zero divide */
%EM_INVALID     = &H00000010???              ' /*   invalid */

%MCW_RC         = &H00000300???              ' /* Rounding Control */
%RC_NEAR        = &H00000000???              ' /*   near */
%RC_DOWN        = &H00000100???              ' /*   down */
%RC_UP          = &H00000200???              ' /*   up */
%RC_CHOP        = &H00000300???              ' /*   chop */

'/*
' * Abstract User Status Word bit definitions
' */

%SW_INEXACT     = &H00000001???              ' /* inexact (precision) */
%SW_UNDERFLOW   = &H00000002???              ' /* underflow */
%SW_OVERFLOW    = &H00000004???              ' /* overflow */
%SW_ZERODIVIDE  = &H00000008???              ' /* zero divide */
%SW_INVALID     = &H00000010???              ' /* invalid */


'/*
' * i386 specific definitions
' */
%MCW_PC         = &H00030000???              ' /* Precision Control */
'#IF %DEF(%M_MPPC)
'' /*
' * PowerMac specific definitions(no precision control)
' */
'%PC_64          = &H00000000???              ' /*    64 bits */
'%PC_53          = &H00000000???              ' /*    53 bits */
'%PC_24          = &H00000000???              ' /*    24 bits */
'#ELSE
%PC_64          = &H00000000???              ' /*    64 bits */
%PC_53          = &H00010000???              ' /*    53 bits */
%PC_24          = &H00020000???              ' /*    24 bits */
'#ENDIF

%MCW_IC         = &H00040000???              ' /* Infinity Control */
%IC_AFFINE      = &H00040000???              ' /*   affine */
%IC_PROJECTIVE  = &H00000000???              ' /*   projective */

%EM_DENORMAL    = &H00080000???              ' /* denormal exception mask (_control87 only) */

%SW_DENORMAL    = &H00080000???              ' /* denormal status bit */


'_CRTIMP unsigned int __cdecl _control87(unsigned int,unsigned int);
Declare Function control87 CDecl Lib "msvcrt.dll" Alias "_control87" ( _
   ByVal Dword, _                           ' unsigned int new
   ByVal Dword _                            ' unsigned int mask
   ) As Dword                               ' unsigned int


'/*
' * RISC specific definitions
' */

%MCW_DN         = &H03000000???                  ' /* Denormal Control */
%DN_SAVE        = &H00000000???                  ' /*   save denormal results and operands */
%DN_FLUSH       = &H01000000???                  ' /*   flush denormal results and operands to zero */
%DN_FLUSH_OPERANDS_SAVE_RESULTS = &H02000000???  ' /*   flush operands to zero and save results */
%DN_SAVE_OPERANDS_FLUSH_RESULTS = &H03000000???  ' /*   save operands and flush results to zero */


'/* initial Control Word value */

'#if     defined(_M_IX86)

'#define _CW_DEFAULT ( _RC_NEAR + _PC_53 + _EM_INVALID + _EM_ZERODIVIDE + _EM_OVERFLOW + _EM_UNDERFLOW + _EM_INEXACT + _EM_DENORMAL)

'#elif   defined(_MAC)

'#define _CW_DEFAULT ( _RC_NEAR + _PC_64 + _EM_INVALID + _EM_ZERODIVIDE + _EM_OVERFLOW + _EM_UNDERFLOW + _EM_INEXACT )

'#elif   defined(_M_MRX000) || defined (_M_ALPHA) || defined(_M_PPC)

'#define _CW_DEFAULT ( _RC_NEAR + _DN_FLUSH + _EM_INVALID + _EM_ZERODIVIDE + _EM_OVERFLOW + _EM_UNDERFLOW + _EM_INEXACT )

'#endif

%CW_DEFAULT = %RC_NEAR + %PC_53 + %EM_INVALID + %EM_ZERODIVIDE + %EM_OVERFLOW + %EM_UNDERFLOW + %EM_INEXACT + %EM_DENORMAL

'/* Global variable holding floating point error code */

'#if     defined(_MT) || defined(_DLL)
'_CRTIMP extern int * __cdecl __fpecode(void);
'#define _fpecode        (*__fpecode())
'#else   /* ndef _MT && ndef _DLL */
'extern int _fpecode;
'#endif  /* _MT || _DLL */

Function pb_fpecode () As Long
   Local hLib As Dword
   Local pfpecode As Long Ptr
   hLib = LoadLibrary("msvcrt.dll")
   If hLib Then
      pfpecode = GetProcAddress(hLib, "__fpecode")
      If pfpecode Then Function = @pfpecode
      FreeLibrary hLib
   End If
End Function


'/* invalid subconditions (_SW_INVALID also set) */

%SW_UNEMULATED          = &H0040???  ' /* unemulated instruction */
%SW_SQRTNEG             = &H0080???  ' /* square root of a neg number */
%SW_STACKOVERFLOW       = &H0200???  ' /* FP stack overflow */
%SW_STACKUNDERFLOW      = &H0400???  ' /* FP stack underflow */

'/*  Floating point error signals and return codes */

%FPE_INVALID            = &H81&
%FPE_DENORMAL           = &H82&
%FPE_ZERODIVIDE         = &H83&
%FPE_OVERFLOW           = &H84&
%FPE_UNDERFLOW          = &H85&
%FPE_INEXACT            = &H86&

%FPE_UNEMULATED         = &H87&
%FPE_SQRTNEG            = &H88&
%FPE_STACKOVERFLOW      = &H8a&
%FPE_STACKUNDERFLOW     = &H8b&

%FPE_EXPLICITGEN        = &H8c&   ' /* raise( SIGFPE ); */


'/* IEEE recommended functions */

'_CRTIMP double __cdecl _copysign (double, double);
Declare Function copysign CDecl Lib "msvcrt.dll" Alias "_copysign" ( _
   ByVal Double, _                         ' double x
   ByVal Double _                          ' double y
   ) As Double                             ' double

'_CRTIMP double __cdecl _chgsign (double);
Declare Function chgsign CDecl Lib "msvcrt.dll" Alias "_chgsign" ( _
   ByVal Double _                          ' double x
   ) As Double                             ' double

'_CRTIMP double __cdecl _scalb(double, long);
Declare Function scalb CDecl Lib "msvcrt.dll" Alias "_scalb" ( _
   ByVal Double, _                         ' double x
   ByVal Long _                            ' long exp
   ) As Double                             ' double

'_CRTIMP double __cdecl _logb(double);
Declare Function logb CDecl Lib "msvcrt.dll" Alias "_logb" ( _
   ByVal Double _                          ' double x
   ) As Double                             ' double

'_CRTIMP double __cdecl _nextafter(double, double);
Declare Function nextafter CDecl Lib "msvcrt.dll" Alias "_nextafter" ( _
   ByVal Double, _                         ' double x
   ByVal Double _                          ' double y
   ) As Double                             ' double

'_CRTIMP int    __cdecl _finite(double);
Declare Function finite CDecl Lib "msvcrt.dll" Alias "_finite" ( _
   ByVal Double _                          ' double x
   ) As Long                               ' int

'_CRTIMP int    __cdecl _isnan(double);
Declare Function isnan CDecl Lib "msvcrt.dll" Alias "_isnan" ( _
   ByVal Double _                          ' double x
   ) As Long                               ' int

'_CRTIMP int    __cdecl _fpclass(double);
Declare Function fpclass CDecl Lib "msvcrt.dll" Alias "_fpclass" ( _
   ByVal Double _                          ' double x
   ) As Long                               ' int


%FPCLASS_SNAN   = &H0001&  ' /* signaling NaN */
%FPCLASS_QNAN   = &H0002&  ' /* quiet NaN */
%FPCLASS_NINF   = &H0004&  ' /* negative infinity */
%FPCLASS_NN     = &H0008&  ' /* negative normal */
%FPCLASS_ND     = &H0010&  ' /* negative denormal */
%FPCLASS_NZ     = &H0020&  ' /* -0 */
%FPCLASS_PZ     = &H0040&  ' /* +0 */
%FPCLASS_PD     = &H0080&  ' /* positive denormal */
%FPCLASS_PN     = &H0100&  ' /* positive normal */
%FPCLASS_PINF   = &H0200&  ' /* positive infinity */


#EndIf   '#IF NOT %DEF(%FLOAT_INC)